/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.relics;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.megacrit.cardcrawl.actions.utility.UseCardAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.cards.DamageInfo;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.GameCursor;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.GameDictionary;
import com.megacrit.cardcrawl.helpers.Hitbox;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.helpers.InputHelper;
import com.megacrit.cardcrawl.helpers.MathHelper;
import com.megacrit.cardcrawl.helpers.PowerTip;
import com.megacrit.cardcrawl.helpers.TipHelper;
import com.megacrit.cardcrawl.helpers.TipTracker;
import com.megacrit.cardcrawl.localization.RelicStrings;
import com.megacrit.cardcrawl.localization.TutorialStrings;
import com.megacrit.cardcrawl.monsters.AbstractMonster;
import com.megacrit.cardcrawl.rooms.AbstractRoom;
import com.megacrit.cardcrawl.rooms.ShopRoom;
import com.megacrit.cardcrawl.rooms.TreasureRoomBoss;
import com.megacrit.cardcrawl.screens.mainMenu.MainMenuScreen;
import com.megacrit.cardcrawl.ui.FtueTip;
import com.megacrit.cardcrawl.unlock.UnlockTracker;
import com.megacrit.cardcrawl.vfx.FloatyEffect;
import com.megacrit.cardcrawl.vfx.GlowRelicParticle;
import com.megacrit.cardcrawl.vfx.SmokePuffEffect;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Scanner;

public abstract class AbstractRelic
implements Comparable<AbstractRelic> {
    private static final TutorialStrings tutorialStrings = CardCrawlGame.languagePack.getTutorialString("Relic Tip");
    public static final String[] MSG = AbstractRelic.tutorialStrings.TEXT;
    public static final String[] LABEL = AbstractRelic.tutorialStrings.LABEL;
    public final String name;
    public final String relicId;
    private final RelicStrings relicStrings;
    public final String[] DESCRIPTIONS;
    public boolean energyBased = false;
    public String description;
    public String flavorText = "missing";
    public int cost;
    public int counter = -1;
    public RelicTier tier;
    public ArrayList<PowerTip> tips = new ArrayList();
    public Texture img;
    public Texture largeImg;
    public Texture outlineImg;
    protected static final String IMG_DIR = "images/relics/";
    private static final String OUTLINE_DIR = "images/relics/outline/";
    private static final String L_IMG_DIR = "images/largeRelics/";
    public String imgUrl = "";
    public static final int RAW_W = 128;
    public float currentX;
    public float currentY;
    public float targetX;
    public float targetY;
    private static final float START_X = 50.0f * Settings.scale;
    private static final float START_Y = (float)Settings.HEIGHT - 110.0f * Settings.scale;
    private static final float PAD_X = 80.0f * Settings.scale;
    private static final float PAD_Y = 80.0f * Settings.scale;
    private static final Color PASSIVE_OUTLINE_COLOR = new Color(0.0f, 0.0f, 0.0f, 0.33f);
    public boolean isSeen = false;
    public float scale = Settings.scale;
    private int smallNumber = 23;
    protected boolean pulse = false;
    private float animationTimer = 0.0f;
    public float flashTimer = 0.0f;
    private static final float FLASH_ANIM_TIME = 2.0f;
    private static final float DEFAULT_ANIM_SCALE = 4.0f;
    private float glowTimer = 0.0f;
    private FloatyEffect f_effect = new FloatyEffect(10.0f, 0.2f);
    public boolean isDone = false;
    public boolean isAnimating = false;
    public boolean isObtained = false;
    private LandingSound landingSFX = LandingSound.CLINK;
    public Hitbox hitbox = new Hitbox(-1000.0f, -1000.0f, PAD_X, PAD_Y);
    private static final float OBTAIN_SPEED = 6.0f;
    private static final float OBTAIN_THRESHOLD = 0.5f;
    private float rotation = 0.0f;
    public boolean discarded = false;
    private String assetURL;

    public AbstractRelic(String setId, String imgName, RelicTier tier, LandingSound sfx) {
        this.imgUrl = imgName;
        this.img = ImageMaster.loadImage(IMG_DIR + imgName);
        this.largeImg = ImageMaster.loadImage(L_IMG_DIR + imgName);
        this.outlineImg = ImageMaster.loadImage(OUTLINE_DIR + imgName);
        this.relicId = setId;
        this.relicStrings = CardCrawlGame.languagePack.getRelicStrings(this.relicId);
        this.DESCRIPTIONS = this.relicStrings.DESCRIPTIONS;
        this.name = this.relicStrings.NAME;
        this.description = this.getUpdatedDescription();
        this.flavorText = this.relicStrings.FLAVOR;
        this.tier = tier;
        this.landingSFX = sfx;
        this.assetURL = IMG_DIR + imgName;
        this.tips.add(new PowerTip(this.name, this.description));
        this.initializeTips();
    }

    public void usedUp() {
        this.description = "Its power is all used up.";
        this.tips.clear();
        this.tips.add(new PowerTip(this.name, this.description));
        this.initializeTips();
    }

    public void spawn(float x, float y) {
        if (!(AbstractDungeon.getCurrRoom() instanceof ShopRoom)) {
            AbstractDungeon.effectsQueue.add(new SmokePuffEffect(x, y));
        }
        this.currentX = x;
        this.currentY = y;
        this.isAnimating = true;
        this.isObtained = false;
        if (this.tier == RelicTier.BOSS) {
            this.f_effect.x = 0.0f;
            this.f_effect.y = 0.0f;
            this.targetX = x;
            this.targetY = y;
            this.glowTimer = 0.0f;
        } else {
            this.f_effect.x = 0.0f;
            this.f_effect.y = 0.0f;
        }
        this.hitbox = new Hitbox(-1000.0f, -1000.0f, PAD_X, PAD_Y);
    }

    public int getPrice() {
        switch (this.tier) {
            case STARTER: {
                return 300;
            }
            case COMMON: {
                return 150;
            }
            case UNCOMMON: {
                return 250;
            }
            case RARE: {
                return 300;
            }
            case SHOP: {
                return 200;
            }
            case SPECIAL: {
                return 400;
            }
            case BOSS: {
                return 999;
            }
            case DEPRECATED: {
                return -1;
            }
        }
        return -1;
    }

    public void reorganizeObtain(AbstractPlayer p, int slot, boolean callOnEquip, int relicAmount) {
        this.isDone = true;
        this.isObtained = true;
        p.relics.add(this);
        this.currentX = relicAmount > this.smallNumber ? START_X + (float)slot * this.getAdjustedPadding(relicAmount) : START_X + (float)slot * PAD_X;
        this.currentY = START_Y;
        this.targetX = this.currentX;
        this.targetY = this.currentY;
        this.hitbox = relicAmount > this.smallNumber ? new Hitbox(-1000.0f, -1000.0f, this.getAdjustedPadding(relicAmount), PAD_Y) : new Hitbox(-1000.0f, -1000.0f, PAD_X, PAD_Y);
        this.hitbox.move(this.currentX, this.currentY);
        if (callOnEquip) {
            this.onEquip();
            this.relicTip();
        }
        UnlockTracker.markRelicAsSeen(this.relicId);
    }

    private float getAdjustedPadding(int numRelics) {
        return ((float)Settings.WIDTH - 80.0f * Settings.scale) / (float)numRelics;
    }

    private float getAdjustedScale(int numRelics) {
        return 1.0f - (float)(numRelics + 1 - this.smallNumber) / 50.0f;
    }

    public void instantObtain(AbstractPlayer p, int slot, boolean callOnEquip) {
        this.isDone = true;
        this.isObtained = true;
        if (slot >= p.relics.size()) {
            p.relics.add(this);
        } else {
            p.relics.set(slot, this);
        }
        if (p.relics.size() > this.smallNumber) {
            this.currentX = START_X + (float)slot * this.getAdjustedPadding(p.relics.size());
            AbstractDungeon.player.reorganizeRelics();
        } else {
            this.currentX = START_X + (float)slot * PAD_X;
        }
        this.currentY = START_Y;
        this.targetX = this.currentX;
        this.targetY = this.currentY;
        this.hitbox = p.relics.size() > this.smallNumber ? new Hitbox(-1000.0f, -1000.0f, this.getAdjustedPadding(p.relics.size()), PAD_Y) : new Hitbox(-1000.0f, -1000.0f, PAD_X, PAD_Y);
        this.hitbox.move(this.currentX, this.currentY);
        if (callOnEquip) {
            this.onEquip();
            this.relicTip();
        }
        UnlockTracker.markRelicAsSeen(this.relicId);
        this.getUpdatedDescription();
    }

    public void instantObtain(boolean astrolabeObtain) {
        this.playLandingSFX();
        this.isDone = true;
        this.isObtained = true;
        if (!astrolabeObtain) {
            if (AbstractDungeon.player.relics.size() > this.smallNumber) {
                this.currentX = START_X + (float)AbstractDungeon.player.relics.size() * this.getAdjustedPadding(AbstractDungeon.player.relics.size());
                AbstractDungeon.player.reorganizeRelics();
            } else {
                this.currentX = START_X + (float)AbstractDungeon.player.relics.size() * PAD_X;
            }
        } else if (AbstractDungeon.player.relics.size() > 10) {
            this.currentX = START_X + (float)(AbstractDungeon.player.relics.size() - 1) * this.getAdjustedPadding(AbstractDungeon.player.relics.size());
            AbstractDungeon.player.reorganizeRelics();
        } else {
            this.currentX = START_X + (float)(AbstractDungeon.player.relics.size() - 1) * PAD_X;
        }
        this.currentY = START_Y;
        this.targetX = this.currentX;
        this.targetY = this.currentY;
        this.flash();
        AbstractDungeon.player.relics.add(this);
        this.hitbox = AbstractDungeon.player.relics.size() > this.smallNumber ? new Hitbox(-1000.0f, -1000.0f, this.getAdjustedPadding(AbstractDungeon.player.relics.size()), PAD_Y) : new Hitbox(-1000.0f, -1000.0f, PAD_X, PAD_Y);
        this.hitbox.move(this.currentX, this.currentY);
        this.onEquip();
        this.relicTip();
        UnlockTracker.markRelicAsSeen(this.relicId);
    }

    public void obtain() {
        this.hitbox.hovered = false;
        int row = AbstractDungeon.player.relics.size();
        if (AbstractDungeon.player.relics.size() > this.smallNumber) {
            this.targetX = START_X + (float)row * this.getAdjustedPadding(AbstractDungeon.player.relics.size());
            AbstractDungeon.player.reorganizeRelics();
        } else {
            this.targetX = START_X + (float)row * PAD_X;
        }
        this.targetY = START_Y;
        AbstractDungeon.player.relics.add(this);
        this.relicTip();
        UnlockTracker.markRelicAsSeen(this.relicId);
    }

    public int getColumn() {
        return AbstractDungeon.player.relics.indexOf(this);
    }

    public void relicTip() {
        if (TipTracker.relicCounter < 20 && ++TipTracker.relicCounter >= 1 && !TipTracker.tips.get("RELIC_TIP").booleanValue()) {
            AbstractDungeon.ftue = new FtueTip(LABEL[0], MSG[0], 360.0f * Settings.scale, 760.0f * Settings.scale, FtueTip.TipType.RELIC);
            TipTracker.neverShowAgain("RELIC_TIP");
        }
    }

    public void setCounter(int counter) {
        this.counter = counter;
    }

    public void update() {
        this.updateFlash();
        float scaleMod = 1.0f;
        if (AbstractDungeon.player != null && AbstractDungeon.player.relics.size() > this.smallNumber) {
            scaleMod = this.getAdjustedScale(AbstractDungeon.player.relics.size());
        }
        if (!this.isDone) {
            if (this.isAnimating) {
                this.glowTimer -= Gdx.graphics.getDeltaTime();
                if (this.glowTimer < 0.0f) {
                    this.glowTimer = 0.5f;
                    AbstractDungeon.effectList.add(new GlowRelicParticle(this.img, this.currentX + this.f_effect.x, this.currentY + this.f_effect.y, this.rotation));
                }
                this.f_effect.update();
                this.scale = this.hitbox.hovered ? Settings.scale * 1.5f : MathHelper.scaleLerpSnap(this.scale, Settings.scale * 1.1f * scaleMod);
            } else {
                this.scale = this.hitbox.hovered ? Settings.scale * 1.25f : MathHelper.scaleLerpSnap(this.scale, Settings.scale * scaleMod);
            }
            if (this.isObtained) {
                if (this.rotation != 0.0f) {
                    this.rotation = MathUtils.lerp(this.rotation, 0.0f, Gdx.graphics.getDeltaTime() * 6.0f * 2.0f);
                }
                if (this.currentX != this.targetX) {
                    this.currentX = MathUtils.lerp(this.currentX, this.targetX, Gdx.graphics.getDeltaTime() * 6.0f);
                    if (Math.abs(this.currentX - this.targetX) < 0.5f) {
                        this.currentX = this.targetX;
                    }
                }
                if (this.currentY != this.targetY) {
                    this.currentY = MathUtils.lerp(this.currentY, this.targetY, Gdx.graphics.getDeltaTime() * 6.0f);
                    if (Math.abs(this.currentY - this.targetY) < 0.5f) {
                        this.currentY = this.targetY;
                    }
                }
                if (this.currentY == this.targetY && this.currentX == this.targetX) {
                    this.isDone = true;
                    this.hitbox.move(this.currentX, this.currentY);
                    if (this.tier == RelicTier.BOSS && AbstractDungeon.getCurrRoom() instanceof TreasureRoomBoss) {
                        AbstractDungeon.overlayMenu.proceedButton.show();
                    }
                    this.onEquip();
                }
                this.scale = Settings.scale;
            }
            if (this.hitbox != null) {
                this.hitbox.update();
                if (this.hitbox.hovered && (!AbstractDungeon.isScreenUp || AbstractDungeon.screen == AbstractDungeon.CurrentScreen.BOSS_REWARD) && AbstractDungeon.screen != AbstractDungeon.CurrentScreen.GASHA_UNLOCK && InputHelper.justClickedLeft && !this.isObtained) {
                    if (!this.relicId.equals("Black Blood") && !this.relicId.equals("Ring of the Serpent")) {
                        this.obtain();
                    }
                    InputHelper.justClickedLeft = false;
                    this.isObtained = true;
                    this.f_effect.x = 0.0f;
                    this.f_effect.y = 0.0f;
                }
            }
            if (AbstractDungeon.screen == AbstractDungeon.CurrentScreen.BOSS_REWARD) {
                this.updateAnimation();
            }
        } else {
            this.hitbox.update();
            if (this.hitbox.hovered && AbstractDungeon.topPanel.potionUi.isHidden) {
                this.scale = Settings.scale * 1.25f;
                CardCrawlGame.cursor.changeType(GameCursor.CursorType.INSPECT);
            } else {
                this.scale = MathHelper.scaleLerpSnap(this.scale, Settings.scale * scaleMod);
            }
            this.updateRelicPopupClick();
        }
    }

    private void updateRelicPopupClick() {
        if (this.hitbox.hovered && InputHelper.justClickedLeft) {
            this.hitbox.clickStarted = true;
        }
        if (this.hitbox.clicked) {
            CardCrawlGame.relicPopup.open(this, AbstractDungeon.player.relics);
            this.hitbox.clicked = false;
            this.hitbox.clickStarted = false;
        }
    }

    public void updateDescription(AbstractPlayer.PlayerClass c) {
    }

    public String getUpdatedDescription() {
        return "";
    }

    public void playLandingSFX() {
        switch (this.landingSFX) {
            case CLINK: {
                CardCrawlGame.sound.play("RELIC_DROP_CLINK");
                break;
            }
            case FLAT: {
                CardCrawlGame.sound.play("RELIC_DROP_FLAT");
                break;
            }
            case SOLID: {
                CardCrawlGame.sound.play("RELIC_DROP_ROCKY");
                break;
            }
            case HEAVY: {
                CardCrawlGame.sound.play("RELIC_DROP_HEAVY");
                break;
            }
            case MAGICAL: {
                CardCrawlGame.sound.play("RELIC_DROP_MAGICAL");
                break;
            }
            default: {
                CardCrawlGame.sound.play("RELIC_DROP_CLINK");
            }
        }
    }

    protected void updateAnimation() {
        if (this.animationTimer != 0.0f) {
            this.animationTimer -= Gdx.graphics.getDeltaTime();
            if (this.animationTimer < 0.0f) {
                this.animationTimer = 0.0f;
            }
        }
    }

    private void updateFlash() {
        if (this.flashTimer != 0.0f) {
            this.flashTimer -= Gdx.graphics.getDeltaTime();
            if (this.flashTimer < 0.0f) {
                this.flashTimer = this.pulse ? 1.0f : 0.0f;
            }
        }
    }

    public void onPlayCard(AbstractCard c, AbstractMonster m) {
    }

    public void onObtainCard(AbstractCard c) {
    }

    public void onGainGold() {
    }

    public void onLoseGold() {
    }

    public void onEquip() {
    }

    public void onUnequip() {
    }

    public void atPreBattle() {
    }

    public void atBattleStart() {
    }

    public void atBattleStartPreDraw() {
    }

    public void atTurnStart() {
    }

    public void onPlayerEndTurn() {
    }

    public void onBloodied() {
    }

    public void onNotBloodied() {
    }

    public void onManualDiscard() {
    }

    public void onUseCard(AbstractCard targetCard, UseCardAction useCardAction) {
    }

    public void onVictory() {
    }

    public void onMonsterDeath(AbstractMonster m) {
    }

    public int onPlayerGainBlock(int blockAmount) {
        return blockAmount;
    }

    public int onPlayerHeal(int healAmount) {
        return healAmount;
    }

    public void onMeditate() {
    }

    public void onEnergyRecharge() {
    }

    public void onRest() {
    }

    public void onRitual() {
    }

    public void onEnterRestRoom() {
    }

    public void onRefreshHand() {
    }

    public void onShuffle() {
    }

    public void onSmith() {
    }

    public void onAttack(DamageInfo info, int damageAmount, AbstractCreature target) {
    }

    public int onAttacked(DamageInfo info, int damageAmount) {
        return damageAmount;
    }

    public void onExhaust(AbstractCard card) {
    }

    public void onTrigger() {
    }

    public void onTrigger(AbstractCreature target) {
    }

    public boolean checkTrigger() {
        return false;
    }

    public void onEnterRoom(AbstractRoom room) {
    }

    public void onCardDraw(AbstractCard drawnCard) {
    }

    public void onChestOpen() {
    }

    public void onDrawOrDiscard() {
    }

    public void onMasterDeckChange() {
    }

    public void render(SpriteBatch sb) {
        if (!Settings.hideRelics) {
            if (this.isDone) {
                this.renderOutline(sb);
            }
            if (!(this.isObtained || AbstractDungeon.isScreenUp && AbstractDungeon.screen != AbstractDungeon.CurrentScreen.BOSS_REWARD && AbstractDungeon.screen != AbstractDungeon.CurrentScreen.SHOP)) {
                if (this.hitbox.hovered && Settings.RELIC_TIP) {
                    this.renderTip(sb);
                }
                if (AbstractDungeon.screen == AbstractDungeon.CurrentScreen.BOSS_REWARD) {
                    if (this.hitbox.hovered) {
                        sb.setColor(PASSIVE_OUTLINE_COLOR);
                        sb.draw(this.outlineImg, this.currentX - 64.0f + this.f_effect.x, this.currentY - 64.0f + this.f_effect.y, 64.0f, 64.0f, 128.0f, 128.0f, this.scale, this.scale, this.rotation, 0, 0, 128, 128, false, false);
                    } else {
                        sb.setColor(PASSIVE_OUTLINE_COLOR);
                        sb.draw(this.outlineImg, this.currentX - 64.0f + this.f_effect.x, this.currentY - 64.0f + this.f_effect.y, 64.0f, 64.0f, 128.0f, 128.0f, this.scale, this.scale, this.rotation, 0, 0, 128, 128, false, false);
                    }
                }
            }
            if (AbstractDungeon.screen == AbstractDungeon.CurrentScreen.BOSS_REWARD) {
                if (!this.isObtained) {
                    sb.setColor(Color.WHITE);
                    sb.draw(this.img, this.currentX - 64.0f + this.f_effect.x, this.currentY - 64.0f + this.f_effect.y, 64.0f, 64.0f, 128.0f, 128.0f, this.scale, this.scale, this.rotation, 0, 0, 128, 128, false, false);
                } else {
                    sb.setColor(Color.WHITE);
                    sb.draw(this.img, this.currentX - 64.0f, this.currentY - 64.0f, 64.0f, 64.0f, 128.0f, 128.0f, this.scale, this.scale, this.rotation, 0, 0, 128, 128, false, false);
                    this.renderCounter(sb);
                }
            } else {
                sb.setColor(Color.WHITE);
                sb.draw(this.img, this.currentX - 64.0f, this.currentY - 64.0f, 64.0f, 64.0f, 128.0f, 128.0f, this.scale, this.scale, this.rotation, 0, 0, 128, 128, false, false);
                this.renderCounter(sb);
            }
            if (this.isDone) {
                this.renderFlash(sb);
            }
            this.hitbox.render(sb);
        }
    }

    public void renderLock(SpriteBatch sb, Color outlineColor) {
        sb.setColor(outlineColor);
        sb.draw(ImageMaster.RELIC_LOCK_OUTLINE, this.currentX - 64.0f, this.currentY - 64.0f, 64.0f, 64.0f, 128.0f, 128.0f, this.scale, this.scale, this.rotation, 0, 0, 128, 128, false, false);
        sb.setColor(Color.WHITE);
        sb.draw(ImageMaster.RELIC_LOCK, this.currentX - 64.0f, this.currentY - 64.0f, 64.0f, 64.0f, 128.0f, 128.0f, this.scale, this.scale, this.rotation, 0, 0, 128, 128, false, false);
        if (this.hitbox.hovered) {
            String unlockReq = UnlockTracker.unlockReqs.get(this.relicId);
            if (unlockReq == null) {
                unlockReq = "Missing unlock req.";
            }
            unlockReq = LABEL[2];
            if ((float)InputHelper.mX < 1400.0f * Settings.scale) {
                if (CardCrawlGame.mainMenuScreen.screen == MainMenuScreen.CurScreen.RELIC_VIEW && (float)InputHelper.mY < (float)Settings.HEIGHT / 5.0f) {
                    TipHelper.renderGenericTip((float)InputHelper.mX + 60.0f * Settings.scale, (float)InputHelper.mY + 100.0f * Settings.scale, LABEL[3], unlockReq);
                } else {
                    TipHelper.renderGenericTip((float)InputHelper.mX + 60.0f * Settings.scale, (float)InputHelper.mY - 50.0f * Settings.scale, LABEL[3], unlockReq);
                }
            } else {
                TipHelper.renderGenericTip((float)InputHelper.mX - 350.0f * Settings.scale, (float)InputHelper.mY - 50.0f * Settings.scale, LABEL[3], unlockReq);
            }
            float tmpX = this.currentX;
            float tmpY = this.currentY;
            if (AbstractDungeon.screen == AbstractDungeon.CurrentScreen.BOSS_REWARD) {
                tmpX += this.f_effect.x;
                tmpY += this.f_effect.y;
            }
            sb.setColor(Color.WHITE);
            sb.draw(ImageMaster.RELIC_LOCK, tmpX - 64.0f, tmpY - 64.0f, 64.0f, 64.0f, 128.0f, 128.0f, this.scale, this.scale, this.rotation, 0, 0, 128, 128, false, false);
        }
        this.hitbox.render(sb);
    }

    public void render(SpriteBatch sb, boolean renderAmount, Color outlineColor) {
        if (!this.isSeen) {
            this.renderOutline(Color.LIGHT_GRAY, sb);
        } else {
            this.renderOutline(outlineColor, sb);
        }
        if (!this.isSeen) {
            if (this.hitbox.hovered) {
                sb.setColor(new Color(0.0f, 0.0f, 0.0f, 0.5f));
            } else {
                sb.setColor(Color.BLACK);
            }
        } else {
            sb.setColor(Color.WHITE);
        }
        if (AbstractDungeon.screen != null && AbstractDungeon.screen == AbstractDungeon.CurrentScreen.GASHA_UNLOCK) {
            if (this.largeImg == null) {
                sb.draw(this.img, this.currentX - 64.0f, this.currentY - 64.0f, 64.0f, 64.0f, 128.0f, 128.0f, Settings.scale * 2.0f + MathUtils.cosDeg(System.currentTimeMillis() / 5L % 360L) / 15.0f, Settings.scale * 2.0f + MathUtils.cosDeg(System.currentTimeMillis() / 5L % 360L) / 15.0f, this.rotation, 0, 0, 128, 128, false, false);
            } else {
                sb.draw(this.largeImg, this.currentX - 128.0f, this.currentY - 128.0f, 128.0f, 128.0f, 256.0f, 256.0f, Settings.scale * 1.0f + MathUtils.cosDeg(System.currentTimeMillis() / 5L % 360L) / 30.0f, Settings.scale * 1.0f + MathUtils.cosDeg(System.currentTimeMillis() / 5L % 360L) / 30.0f, this.rotation, 0, 0, 256, 256, false, false);
            }
        } else {
            sb.draw(this.img, this.currentX - 64.0f, this.currentY - 64.0f, 64.0f, 64.0f, 128.0f, 128.0f, this.scale, this.scale, this.rotation, 0, 0, 128, 128, false, false);
        }
        if (this.hitbox.hovered) {
            if (!this.isSeen) {
                if ((float)InputHelper.mX < 1400.0f * Settings.scale) {
                    TipHelper.renderGenericTip((float)InputHelper.mX + 60.0f * Settings.scale, (float)InputHelper.mY - 50.0f * Settings.scale, LABEL[1], MSG[1]);
                } else {
                    TipHelper.renderGenericTip((float)InputHelper.mX - 350.0f * Settings.scale, (float)InputHelper.mY - 50.0f * Settings.scale, LABEL[1], MSG[1]);
                }
                return;
            }
            if (Settings.RELIC_TIP) {
                this.renderTip(sb);
            }
        }
        this.hitbox.render(sb);
    }

    public void renderWithoutAmount(SpriteBatch sb, Color c) {
        this.renderOutline(c, sb);
        sb.setColor(Color.WHITE);
        sb.draw(this.img, this.currentX - 64.0f, this.currentY - 64.0f, 64.0f, 64.0f, 128.0f, 128.0f, this.scale, this.scale, this.rotation, 0, 0, 128, 128, false, false);
        if (this.hitbox.hovered) {
            if (Settings.RELIC_TIP) {
                this.renderTip(sb);
            }
            float tmpX = this.currentX;
            float tmpY = this.currentY;
            if (AbstractDungeon.screen == AbstractDungeon.CurrentScreen.BOSS_REWARD) {
                tmpX += this.f_effect.x;
                tmpY += this.f_effect.y;
            }
            sb.setColor(Color.WHITE);
            sb.draw(this.img, tmpX - 64.0f, tmpY - 64.0f, 64.0f, 64.0f, 128.0f, 128.0f, this.scale, this.scale, this.rotation, 0, 0, 128, 128, false, false);
        }
        this.hitbox.render(sb);
    }

    public void renderCounter(SpriteBatch sb) {
        if (this.counter > -1) {
            if (AbstractDungeon.player.relics.size() > this.smallNumber) {
                FontHelper.renderFontRightTopAligned(sb, FontHelper.topPanelInfoFont, Integer.toString(this.counter), this.currentX + 30.0f * Settings.scale * this.getAdjustedScale(AbstractDungeon.player.relics.size()), this.currentY - 7.0f * Settings.scale * this.getAdjustedScale(AbstractDungeon.player.relics.size()), Color.WHITE);
            } else {
                FontHelper.renderFontRightTopAligned(sb, FontHelper.topPanelInfoFont, Integer.toString(this.counter), this.currentX + 30.0f * Settings.scale, this.currentY - 7.0f * Settings.scale, Color.WHITE);
            }
        }
    }

    public void renderOutline(Color c, SpriteBatch sb) {
        sb.setColor(c);
        if (AbstractDungeon.screen != null && AbstractDungeon.screen == AbstractDungeon.CurrentScreen.GASHA_UNLOCK) {
            sb.draw(this.outlineImg, this.currentX - 64.0f, this.currentY - 64.0f, 64.0f, 64.0f, 128.0f, 128.0f, Settings.scale * 2.0f + MathUtils.cosDeg(System.currentTimeMillis() / 5L % 360L) / 15.0f, Settings.scale * 2.0f + MathUtils.cosDeg(System.currentTimeMillis() / 5L % 360L) / 15.0f, this.rotation, 0, 0, 128, 128, false, false);
        } else {
            sb.draw(this.outlineImg, this.currentX - 64.0f, this.currentY - 64.0f, 64.0f, 64.0f, 128.0f, 128.0f, this.scale, this.scale, this.rotation, 0, 0, 128, 128, false, false);
        }
    }

    public void renderOutline(SpriteBatch sb) {
        sb.setColor(PASSIVE_OUTLINE_COLOR);
        sb.draw(this.outlineImg, this.currentX - 64.0f, this.currentY - 64.0f, 64.0f, 64.0f, 128.0f, 128.0f, this.scale, this.scale, this.rotation, 0, 0, 128, 128, false, false);
    }

    public void renderFlash(SpriteBatch sb) {
        float tmp = Interpolation.exp10In.apply(0.0f, 4.0f, this.flashTimer / 2.0f);
        sb.setBlendFunction(770, 1);
        sb.setColor(new Color(1.0f, 1.0f, 1.0f, this.flashTimer * 0.2f));
        sb.draw(this.img, this.currentX - 64.0f, this.currentY - 64.0f, 64.0f, 64.0f, 128.0f, 128.0f, this.scale + tmp, this.scale + tmp, this.rotation, 0, 0, 128, 128, false, false);
        sb.draw(this.img, this.currentX - 64.0f, this.currentY - 64.0f, 64.0f, 64.0f, 128.0f, 128.0f, this.scale + tmp * 0.66f, this.scale + tmp * 0.66f, this.rotation, 0, 0, 128, 128, false, false);
        sb.draw(this.img, this.currentX - 64.0f, this.currentY - 64.0f, 64.0f, 64.0f, 128.0f, 128.0f, this.scale + tmp / 3.0f, this.scale + tmp / 3.0f, this.rotation, 0, 0, 128, 128, false, false);
        sb.setBlendFunction(770, 771);
    }

    public void beginPulse() {
        this.flashTimer = 1.0f;
    }

    public void beginLongPulse() {
        this.flashTimer = 1.0f;
        this.pulse = true;
    }

    public void stopPulse() {
        this.pulse = false;
    }

    public void flash() {
        this.flashTimer = 2.0f;
    }

    public void renderTip(SpriteBatch sb) {
        if ((float)InputHelper.mX < 1400.0f * Settings.scale) {
            if (CardCrawlGame.mainMenuScreen.screen == MainMenuScreen.CurScreen.RELIC_VIEW && (float)InputHelper.mY < (float)Settings.HEIGHT / 2.0f) {
                TipHelper.queuePowerTips((float)InputHelper.mX + 60.0f * Settings.scale, (float)Settings.HEIGHT / 2.0f, this.tips);
            } else if (AbstractDungeon.screen == AbstractDungeon.CurrentScreen.SHOP && this.tips.size() > 2 && !AbstractDungeon.player.hasRelic(this.relicId)) {
                TipHelper.queuePowerTips((float)InputHelper.mX + 60.0f * Settings.scale, (float)InputHelper.mY + 180.0f * Settings.scale, this.tips);
            } else if (AbstractDungeon.player != null && AbstractDungeon.player.hasRelic(this.relicId)) {
                TipHelper.queuePowerTips((float)InputHelper.mX + 60.0f * Settings.scale, (float)InputHelper.mY - 30.0f * Settings.scale, this.tips);
            } else if (AbstractDungeon.screen == AbstractDungeon.CurrentScreen.COMBAT_REWARD) {
                TipHelper.queuePowerTips((float)InputHelper.mX + 50.0f * Settings.scale, (float)InputHelper.mY + 50.0f * Settings.scale, this.tips);
            } else {
                TipHelper.queuePowerTips((float)InputHelper.mX + 50.0f * Settings.scale, (float)InputHelper.mY + 50.0f * Settings.scale, this.tips);
            }
        } else {
            TipHelper.queuePowerTips((float)InputHelper.mX - 350.0f * Settings.scale, (float)InputHelper.mY - 50.0f * Settings.scale, this.tips);
        }
    }

    public boolean canPlay(AbstractCard card) {
        return true;
    }

    public static String debugDetailedRelicDataHeader() {
        StringBuilder builder = new StringBuilder();
        AbstractRelic.addFieldData(builder, "name");
        AbstractRelic.addFieldData(builder, "color");
        AbstractRelic.addFieldData(builder, "description");
        AbstractRelic.addFieldData(builder, "flavorText");
        AbstractRelic.addFieldData(builder, "cost");
        AbstractRelic.addFieldData(builder, "tier");
        AbstractRelic.addFieldData(builder, "assetURL");
        return builder.toString();
    }

    protected void initializeTips() {
        Scanner desc = new Scanner(this.description);
        while (desc.hasNext()) {
            String s = desc.next();
            String copy = "";
            if (s.charAt(0) == '#') {
                s = s.substring(2);
            }
            s = s.replace(',', ' ');
            s = s.replace('.', ' ');
            s = s.trim();
            copy = new String(s);
            s = s.toLowerCase();
            boolean alreadyExists = false;
            for (PowerTip t : this.tips) {
                if (!t.header.toLowerCase().equals(copy.toLowerCase())) continue;
                alreadyExists = true;
                break;
            }
            if (alreadyExists || !GameDictionary.keywords.containsKey(s)) continue;
            this.tips.add(new PowerTip(copy, GameDictionary.keywords.get(s)));
        }
        desc.close();
    }

    public String debugDetailedRelicData(String color) {
        StringBuilder builder = new StringBuilder();
        AbstractRelic.addFieldData(builder, this.name);
        AbstractRelic.addFieldData(builder, color);
        AbstractRelic.addFieldData(builder, this.description);
        AbstractRelic.addFieldData(builder, this.flavorText);
        AbstractRelic.addFieldData(builder, this.cost);
        AbstractRelic.addFieldData(builder, this.tier.name());
        AbstractRelic.addFieldData(builder, this.assetURL);
        return builder.toString();
    }

    private static void addFieldData(StringBuilder builder, String value) {
        builder.append(value).append("\t");
    }

    private static void addFieldData(StringBuilder builder, int value) {
        AbstractRelic.addFieldData(builder, Integer.toString(value));
    }

    public abstract AbstractRelic makeCopy();

    public AbstractRelic makeCopy(AbstractPlayer.PlayerClass chosenClass) {
        return null;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(AbstractRelic arg0) {
        return this.name.compareTo(arg0.name);
    }

    public String getAssetURL() {
        return this.assetURL;
    }

    public HashMap<String, Serializable> getLocStrings() {
        HashMap<String, Serializable> relicData = new HashMap<String, Serializable>();
        relicData.put("name", (Serializable)((Object)this.name));
        relicData.put("description", (Serializable)((Object)this.description));
        return relicData;
    }

    public void onUsePotion() {
    }

    public void onLoseHp(int damageAmount) {
    }

    public static enum RelicTier {
        DEPRECATED,
        STARTER,
        COMMON,
        UNCOMMON,
        RARE,
        SPECIAL,
        BOSS,
        SHOP;

    }

    public static enum LandingSound {
        CLINK,
        FLAT,
        HEAVY,
        MAGICAL,
        SOLID;

    }
}

